/* This file contains #defines (including macros) that can be used in any ccl file that includes it */

// SAVE_DISPLAY_PREFS saves the current settings of the display preferences for later restoration by RESTORE_DISPLAY_PREFS.
#define SAVE_DISPLAY_PREFS      char glabon=char_pref(glab);char graxon=char_pref(grax);char gaclon=char_pref(gacl);char outpon=char_pref(outp);

// RESTORE_DISPLAY_PREFS resets the display preferences to the values saved by SAVE_DISPLAY_PREFS.
#define RESTORE_DISPLAY_PREFS   if (glabon) stp(glab,on);else stp(glab,off);if (graxon) stp(grax,on);else stp(grax,off);if (gaclon) stp(gacl,on);else stp(gacl,off); if(outpon) stp(outp,on);else stp(outp,off);

// GET_UNITS_STRING returns a string representing the current units in the str1 global variable.
#define GET_UNITS_STRING        "if (uni==1.0) strcpy(str1,\"mm\");else if(uni==10.0)strcpy(str1,\"cm\");else if(uni==25.4)strcpy(str1,\"in\");else if(uni==1000.0)strcpy(str1,\"m\");else if(uni==0.001)strcpy(str1,\"@vm\");else sprintf(str1,\"%.3g\",uni);"

#define FALSE                0
#define TRUE                 1

#define SLIDERBASEWIN       32
#define SMATDIM            101

#define MAX_BLUE_COLOR     185
#define MIN_RED_COLOR      138
#define MAX_WHITE_COLOR     41
#define MIN_BLACK_COLOR      9

#define _2DMAXDIM           10
#define _2DMAXPLOTS        100

#define SMALL_EPSILON  1.0e-40
#define MIN_INFINITE_TH 9.9e+7
#define RAYFAILVALUE      1e20
